<?php

namespace app\controllers;

use Yii;
use yii\web\Controller;
use app\models\User;
use yii\filters\AccessControl;

class AuthController extends Controller
{
    public function behaviors()
    {
        return [
            'access' => [
                'class' => AccessControl::class,
                'only' => ['logout'],
                'rules' => [
                    [
                        'actions' => ['logout'],
                        'allow' => true,
                        'roles' => ['@'],
                    ],
                ],
            ],
        ];
    }

    public function actionRegister()
    {
        $model = new User();

        if ($model->load(Yii::$app->request->post()) && $model->validate()) {
            if ($model->save()) {
                Yii::$app->session->setFlash('success', 'Регистрация прошла успешно! Теперь вы можете войти.');
                return $this->redirect(['login']);
            }
        }

        return $this->render('register', [
            'model' => $model,
        ]);
    }

    public function actionLogin()
    {
        if (!Yii::$app->user->isGuest) {
            return $this->goHome();
        }

        // Создаем модель только для формы
        $model = new User();

        if (Yii::$app->request->isPost) {
            $phone = Yii::$app->request->post('User')['phone'] ?? '';
            $password = Yii::$app->request->post('User')['password'] ?? '';

            $user = User::findByPhone($phone);
            if ($user && $user->validatePassword($password)) {
                Yii::$app->user->login($user, 3600*24*30); // Запомнить на 30 дней
                return $this->goBack();
            } else {
                Yii::$app->session->setFlash('error', 'Неверный телефон или пароль');
            }
        }

        $model->password = '';
        return $this->render('login', [
            'model' => $model,
        ]);
    }

    public function actionLogout()
    {
        Yii::$app->user->logout();
        return $this->goHome();
    }
}