<?php

namespace app\controllers;

use Yii;
use yii\web\Controller;
use yii\filters\AccessControl;
use app\models\User;
use app\models\MeterReading;

class ProfileController extends Controller
{
    public function behaviors()
    {
        return [
            'access' => [
                'class' => AccessControl::class,
                'rules' => [
                    [
                        'allow' => true,
                        'roles' => ['@'],
                    ],
                ],
            ],
        ];
    }

    public function actionIndex()
    {
        $model = User::findOne(Yii::$app->user->id);
        $model->scenario = 'update';

        if ($model->load(Yii::$app->request->post())) {
            // Валидация только если пароль введен
            if ($model->password) {
                if (!$model->validate()) {
                    Yii::$app->session->setFlash('error', 'Исправьте ошибки в форме.');
                } else {
                    if ($this->updateUser($model)) {
                        Yii::$app->session->setFlash('success', 'Данные успешно обновлены.');
                        return $this->refresh();
                    }
                }
            } else {
                // Если пароль не меняется, сохраняем без валидации пароля
                if ($model->save(false)) {
                    Yii::$app->session->setFlash('success', 'Данные успешно обновлены.');
                    return $this->refresh();
                }
            }
        }

        // Получаем статистику по показаниям
        $readingsCount = MeterReading::find()
            ->where(['user_id' => Yii::$app->user->id])
            ->count();

        $approvedCount = MeterReading::find()
            ->where(['user_id' => Yii::$app->user->id, 'status' => 'approved'])
            ->count();

        $newCount = MeterReading::find()
            ->where(['user_id' => Yii::$app->user->id, 'status' => 'new'])
            ->count();

        // Последние 5 показаний
        $recentReadings = MeterReading::find()
            ->where(['user_id' => Yii::$app->user->id])
            ->orderBy(['created_at' => SORT_DESC])
            ->limit(5)
            ->all();

        // Очищаем пароль, чтобы не показывать хеш
        $model->password = '';
        $model->password_repeat = '';

        return $this->render('index', [
            'model' => $model,
            'readingsCount' => $readingsCount,
            'approvedCount' => $approvedCount,
            'newCount' => $newCount,
            'recentReadings' => $recentReadings,
        ]);
    }

    /**
     * Обновление данных пользователя с хешированием пароля
     */
    private function updateUser($model)
    {
        if ($model->password) {
            $model->password_hash = Yii::$app->security->generatePasswordHash($model->password);
        }

        return $model->save(false); // false чтобы не запускать повторную валидацию
    }
}