<?php

namespace app\controllers;

use Yii;
use yii\web\Controller;
use app\models\SliderImage;
use app\models\UtilityType;

class SiteController extends Controller
{
    public function actions()
    {
        return [
            'error' => [
                'class' => 'yii\web\ErrorAction',
            ],
        ];
    }

    public function actionIndex()
    {
        // Получаем изображения для слайдера
        $sliderImages = SliderImage::find()
            ->where(['is_active' => 1])
            ->orderBy(['order_index' => SORT_ASC])
            ->all();

        // Получаем типы услуг для отображения тарифов
        $utilityTypes = UtilityType::find()->all();

        return $this->render('index', [
            'sliderImages' => $sliderImages,
            'utilityTypes' => $utilityTypes,
        ]);
    }

    public function actionAbout()
    {
        return $this->render('about');
    }

    public function actionTariffs()
    {
        return $this->render('tariffs');
    }

    public function actionFaq()
    {
        return $this->render('faq');
    }
}