<?php

use yii\db\Migration;

class m251126_141837_init_kommunalka_tables extends Migration
{
    public function safeUp()
    {
        $tableOptions = null;
        if ($this->db->driverName === 'mysql') {
            $tableOptions = 'CHARACTER SET utf8 COLLATE utf8_unicode_ci ENGINE=InnoDB';
        }

        // Таблица пользователей
        $this->createTable('{{%users}}', [
            'id' => $this->primaryKey(),
            'full_name' => $this->string(255)->notNull(),
            'phone' => $this->string(20)->notNull()->unique(),
            'email' => $this->string(255)->notNull()->unique(),
            'address' => $this->text()->notNull(),
            'residents_count' => $this->integer()->notNull(),
            'password_hash' => $this->string(255)->notNull(),
            'created_at' => $this->dateTime()->defaultExpression('CURRENT_TIMESTAMP'),
            'updated_at' => $this->dateTime()->defaultExpression('CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP'),
        ], $tableOptions);

        // Таблица типов коммунальных услуг
        $this->createTable('{{%utility_types}}', [
            'id' => $this->primaryKey(),
            'name' => $this->string(100)->notNull(),
            'tariff' => $this->decimal(10,2)->notNull(),
            'unit' => $this->string(20)->notNull(),
        ], $tableOptions);

        // Таблица показаний счетчиков
        $this->createTable('{{%meter_readings}}', [
            'id' => $this->primaryKey(),
            'user_id' => $this->integer()->notNull(),
            'utility_type_id' => $this->integer()->notNull(),
            'previous_reading' => $this->decimal(10,2)->notNull(),
            'current_reading' => $this->decimal(10,2)->notNull(),
            'consumption' => $this->decimal(10,2)->notNull(),
            'amount' => $this->decimal(10,2)->notNull(),
            'reading_date' => $this->date()->notNull(),
            'status' => $this->string(20)->defaultValue('new'),
            'created_at' => $this->dateTime()->defaultExpression('CURRENT_TIMESTAMP'),
        ], $tableOptions);

        // Внешние ключи
        $this->addForeignKey(
            'fk-meter_readings-user_id',
            '{{%meter_readings}}',
            'user_id',
            '{{%users}}',
            'id',
            'CASCADE'
        );

        $this->addForeignKey(
            'fk-meter_readings-utility_type_id',
            '{{%meter_readings}}',
            'utility_type_id',
            '{{%utility_types}}',
            'id',
            'CASCADE'
        );

        // Таблица для слайдера
        $this->createTable('{{%slider_images}}', [
            'id' => $this->primaryKey(),
            'image_path' => $this->string(255)->notNull(),
            'title' => $this->string(255),
            'description' => $this->text(),
            'order_index' => $this->integer()->defaultValue(0),
            'is_active' => $this->boolean()->defaultValue(1),
        ], $tableOptions);

        // Заполняем типы коммунальных услуг
        $this->batchInsert('{{%utility_types}}', ['name', 'tariff', 'unit'], [
            ['электричество', 5.03, 'кВт·ч'],
            ['газ', 7.39, 'м³'],
            ['вода', 48.24, 'м³'],
        ]);

        // Добавляем изображения для слайдера
        $this->batchInsert('{{%slider_images}}', ['image_path', 'title', 'description', 'order_index'], [
            ['/images/slider1.jpg', 'Удобная передача показаний', 'Передавайте показания онлайн без очередей', 1],
            ['/images/slider2.jpg', 'Прозрачные расчеты', 'Все расчеты автоматические и понятные', 2],
            ['/images/slider3.jpg', 'История платежей', 'Вся история ваших платежей в одном месте', 3],
            ['/images/slider4.jpg', 'Поддержка 24/7', 'Мы всегда готовы помочь с любыми вопросами', 4],
        ]);
    }

    public function safeDown()
    {
        $this->dropTable('{{%meter_readings}}');
        $this->dropTable('{{%utility_types}}');
        $this->dropTable('{{%slider_images}}');
        $this->dropTable('{{%users}}');
    }
}
