<?php

namespace app\models;

use Yii;
use yii\db\ActiveRecord;
use yii\web\IdentityInterface;

class User extends ActiveRecord implements IdentityInterface
{
    public $password;
    public $password_repeat;
    public $agree;

    public static function tableName()
    {
        return 'users';
    }

    public function rules()
    {
        return [
            [['full_name', 'phone', 'email', 'address', 'residents_count', 'password', 'password_repeat', 'agree'], 'required'],
            ['full_name', 'match', 'pattern' => '/^[а-яА-ЯёЁ\s]+$/u'],
            ['phone', 'match', 'pattern' => '/^8\(\d{3}\)\d{3}-\d{2}-\d{2}$/'],
            ['email', 'email'],
            ['password', 'string', 'min' => 10],
            ['password_repeat', 'compare', 'compareAttribute' => 'password'],
            ['agree', 'compare', 'compareValue' => true, 'message' => 'Необходимо согласие с правилами'],
            [['phone', 'email'], 'unique'],
            ['residents_count', 'integer', 'min' => 1],
        ];
    }

    public function attributeLabels()
    {
        return [
            'full_name' => 'ФИО',
            'phone' => 'Телефон',
            'email' => 'Email',
            'address' => 'Адрес проживания',
            'residents_count' => 'Количество проживающих',
            'password' => 'Пароль',
            'password_repeat' => 'Повтор пароля',
            'agree' => 'Согласие с правилами',
        ];
    }

    public function beforeSave($insert)
    {
        if (parent::beforeSave($insert)) {
            if ($this->isNewRecord || $this->password) {
                $this->password_hash = Yii::$app->security->generatePasswordHash($this->password);
            }
            return true;
        }
        return false;
    }

    // Добавляем метод для получения username
    public function getUsername()
    {
        return $this->phone; // или return $this->email; в зависимости от того, что вы хотите показывать как username
    }

    // IdentityInterface methods
    public static function findIdentity($id)
    {
        return static::findOne($id);
    }

    public static function findIdentityByAccessToken($token, $type = null)
    {
        return null;
    }

    public function getId()
    {
        return $this->id;
    }

    public function getAuthKey()
    {
        return null;
    }

    public function validateAuthKey($authKey)
    {
        return false;
    }
    public function getMeterReadings()
    {
        return $this->hasMany(MeterReading::class, ['user_id' => 'id']);
    }
    public function validatePassword($password)
    {
        return Yii::$app->security->validatePassword($password, $this->password_hash);
    }

    public static function findByPhone($phone)
    {
        return static::findOne(['phone' => $phone]);
    }

    /**
     * @inheritdoc
     */
    public function scenarios()
    {
        $scenarios = parent::scenarios();
        $scenarios['update'] = ['full_name', 'email', 'address', 'residents_count', 'password', 'password_repeat'];
        return $scenarios;
    }
}