<?php

use yii\helpers\Html;
use yii\helpers\Url;
use yii\widgets\ActiveForm;

$this->title = 'Админ-панель - Коммуналка';
?>

    <div class="admin-index">
        <h1>Админ-панель</h1>

        <!-- Статистика -->
        <div class="row mb-4">
            <div class="col-md-3">
                <div class="card text-white bg-primary">
                    <div class="card-body">
                        <div class="d-flex justify-content-between">
                            <div>
                                <h4><?= $stats['total_readings'] ?></h4>
                                <p class="mb-0">Всего показаний</p>
                            </div>
                            <div class="align-self-center">
                                <i class="fas fa-list fa-2x"></i>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
            <div class="col-md-3">
                <div class="card text-white bg-warning">
                    <div class="card-body">
                        <div class="d-flex justify-content-between">
                            <div>
                                <h4><?= $stats['new_readings'] ?></h4>
                                <p class="mb-0">Новые</p>
                            </div>
                            <div class="align-self-center">
                                <i class="fas fa-clock fa-2x"></i>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
            <div class="col-md-3">
                <div class="card text-white bg-success">
                    <div class="card-body">
                        <div class="d-flex justify-content-between">
                            <div>
                                <h4><?= $stats['approved_readings'] ?></h4>
                                <p class="mb-0">Принято</p>
                            </div>
                            <div class="align-self-center">
                                <i class="fas fa-check fa-2x"></i>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
            <div class="col-md-3">
                <div class="card text-white bg-danger">
                    <div class="card-body">
                        <div class="d-flex justify-content-between">
                            <div>
                                <h4><?= $stats['rejected_readings'] ?></h4>
                                <p class="mb-0">Отклонено</p>
                            </div>
                            <div class="align-self-center">
                                <i class="fas fa-times fa-2x"></i>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </div>

        <!-- Фильтры -->
        <div class="card mb-4">
            <div class="card-header">
                <h5 class="card-title mb-0">Фильтры</h5>
            </div>
            <div class="card-body">
                <?php $form = ActiveForm::begin([
                    'method' => 'get',
                    'action' => ['index'],
                ]); ?>

                <div class="row">
                    <div class="col-md-3">
                        <?= $form->field($filterModel, 'status')->dropDownList([
                            '' => 'Все статусы',
                            'new' => 'Новые',
                            'approved' => 'Принятые',
                            'rejected' => 'Отклоненные'
                        ]) ?>
                    </div>
                    <div class="col-md-3">
                        <?= $form->field($filterModel, 'utility_type_id')->dropDownList(
                            ['' => 'Все услуги'] + \yii\helpers\ArrayHelper::map($utilityTypes, 'id', 'name')
                        ) ?>
                    </div>
                    <div class="col-md-3">
                        <?= $form->field($filterModel, 'date_from')->textInput(['type' => 'date']) ?>
                    </div>
                    <div class="col-md-3">
                        <?= $form->field($filterModel, 'date_to')->textInput(['type' => 'date']) ?>
                    </div>
                </div>

                <div class="form-group">
                    <?= Html::submitButton('Применить фильтры', ['class' => 'btn btn-primary']) ?>
                    <?= Html::a('Сбросить', ['index'], ['class' => 'btn btn-secondary']) ?>
                </div>

                <?php ActiveForm::end(); ?>
            </div>
        </div>

        <!-- Таблица заявок -->
        <div class="card">
            <div class="card-header d-flex justify-content-between align-items-center">
                <h5 class="card-title mb-0">Заявки на проверку</h5>
                <div>
                    <span class="badge badge-warning">Новые: <?= $stats['new_readings'] ?></span>
                </div>
            </div>
            <div class="card-body">
                <?php if (empty($readings)): ?>
                    <div class="alert alert-info">
                        <h5>Нет заявок для отображения</h5>
                        <p class="mb-0">По выбранным фильтрам заявки не найдены.</p>
                    </div>
                <?php else: ?>
                    <div class="table-responsive">
                        <table class="table table-striped table-bordered">
                            <thead class="thead-dark">
                            <tr>
                                <th>Дата</th>
                                <th>Пользователь</th>
                                <th>Услуга</th>
                                <th>Показания</th>
                                <th>Расход</th>
                                <th>Сумма</th>
                                <th>Статус</th>
                                <th>Действия</th>
                            </tr>
                            </thead>
                            <tbody>
                            <?php foreach ($readings as $reading): ?>
                                <tr>
                                    <td><?= Yii::$app->formatter->asDatetime($reading->created_at, 'php:d.m.Y H:i') ?></td>
                                    <td>
                                        <strong><?= Html::encode($reading->user->full_name) ?></strong><br>
                                        <small class="text-muted"><?= $reading->user->phone ?></small><br>
                                        <small class="text-muted"><?= $reading->user->email ?></small>
                                    </td>
                                    <td><?= Html::encode($reading->utilityType->name) ?></td>
                                    <td>
                                        <small>Пред.: <?= $reading->previous_reading ?></small><br>
                                        <strong>Тек.: <?= $reading->current_reading ?></strong>
                                    </td>
                                    <td><?= $reading->consumption ?> <?= Html::encode($reading->utilityType->unit) ?></td>
                                    <td><?= number_format($reading->amount, 2, '.', ' ') ?> руб.</td>
                                    <td>
                                        <?php
                                        $statusLabels = [
                                            'new' => '<span class="badge badge-warning">Новая</span>',
                                            'approved' => '<span class="badge badge-success">Принята</span>',
                                            'rejected' => '<span class="badge badge-danger">Ошибка</span>'
                                        ];
                                        echo $statusLabels[$reading->status] ?? $reading->status;
                                        ?>
                                    </td>
                                    <td>
                                        <div class="btn-group btn-group-sm">
                                            <?php if ($reading->status == 'new'): ?>
                                                <?= Html::a('Принять', ['update-status', 'id' => $reading->id, 'status' => 'approved'], [
                                                    'class' => 'btn btn-success',
                                                    'data-method' => 'post',
                                                    'data-confirm' => 'Вы уверены, что хотите принять эти показания?'
                                                ]) ?>
                                                <?= Html::a('Отклонить', ['update-status', 'id' => $reading->id, 'status' => 'rejected'], [
                                                    'class' => 'btn btn-danger',
                                                    'data-method' => 'post',
                                                    'data-confirm' => 'Вы уверены, что хотите отклонить эти показания?'
                                                ]) ?>
                                            <?php else: ?>
                                                <?= Html::a('Изменить', ['update-status', 'id' => $reading->id, 'status' => 'new'], [
                                                    'class' => 'btn btn-secondary',
                                                    'data-method' => 'post',
                                                    'data-confirm' => 'Вернуть статус "Новая"?'
                                                ]) ?>
                                            <?php endif; ?>
                                        </div>
                                    </td>
                                </tr>
                            <?php endforeach; ?>
                            </tbody>
                        </table>
                    </div>

                    <!-- Пагинация -->
                    <?= \yii\widgets\LinkPager::widget([
                        'pagination' => $pagination,
                        'options' => ['class' => 'pagination justify-content-center'],
                        'linkContainerOptions' => ['class' => 'page-item'],
                        'linkOptions' => ['class' => 'page-link'],
                        'disabledListItemSubTagOptions' => ['tag' => 'a', 'class' => 'page-link'],
                    ]) ?>
                <?php endif; ?>
            </div>
        </div>

        <!-- Дополнительные функции -->
        <div class="row mt-4">
            <div class="col-md-6">
                <div class="card">
                    <div class="card-header">
                        <h5 class="card-title mb-0">Быстрые действия</h5>
                    </div>
                    <div class="card-body">
                        <div class="d-grid gap-2">
                            <?= Html::a('Просмотреть всех пользователей', ['users'], ['class' => 'btn btn-outline-primary']) ?>
                            <?= Html::a('Экспорт данных', ['export'], ['class' => 'btn btn-outline-success']) ?>
                            <?= Html::a('Настройки тарифов', ['tariffs'], ['class' => 'btn btn-outline-info']) ?>
                        </div>
                    </div>
                </div>
            </div>
            <div class="col-md-6">
                <div class="card">
                    <div class="card-header">
                        <h5 class="card-title mb-0">Системная информация</h5>
                    </div>
                    <div class="card-body">
                        <ul class="list-unstyled">
                            <li><strong>Всего пользователей:</strong> <?= $stats['total_users'] ?></li>
                            <li><strong>Активных заявок:</strong> <?= $stats['new_readings'] ?></li>
                            <li><strong>Общая сумма принятых показаний:</strong> <?= number_format($stats['total_amount'], 2, '.', ' ') ?> руб.</li>
                            <li><strong>Последняя активность:</strong> <?= $stats['last_activity'] ?></li>
                        </ul>
                    </div>
                </div>
            </div>
        </div>
    </div>

<?php
// JavaScript для улучшения UX
$this->registerJs(<<<JS
    // Подтверждение действий
    $('a[data-confirm]').on('click', function(e) {
        if (!confirm($(this).data('confirm'))) {
            e.preventDefault();
        }
    });

    // Автозакрытие алертов через 5 секунд
    setTimeout(function() {
        $('.alert:not(.alert-permanent)').fadeOut('slow');
    }, 5000);

    // Подсветка новых строк
    $('tr').each(function() {
        var status = $(this).find('.badge-warning').length;
        if (status > 0) {
            $(this).addClass('table-warning');
        }
    });
JS
);
?>