<?php

use yii\helpers\Html;
use yii\widgets\ActiveForm;

$this->title = 'Управление тарифами - Админ-панель';
?>

<div class="admin-tariffs">
    <h1>Управление тарифами</h1>

    <div class="card">
        <div class="card-header">
            <h5 class="card-title mb-0">Текущие тарифы</h5>
        </div>
        <div class="card-body">
            <?php $form = ActiveForm::begin(); ?>

            <div class="row">
                <?php foreach ($utilityTypes as $utility): ?>
                    <div class="col-md-4 mb-3">
                        <div class="card">
                            <div class="card-body">
                                <h5 class="card-title"><?= Html::encode($utility->name) ?></h5>
                                <div class="form-group">
                                    <label>Тариф (руб. за <?= Html::encode($utility->unit) ?>)</label>
                                    <?= Html::input('number', "tariff[{$utility->id}]", $utility->tariff, [
                                        'class' => 'form-control',
                                        'step' => '0.01',
                                        'min' => '0',
                                        'required' => true
                                    ]) ?>
                                </div>
                                <small class="text-muted">Текущий тариф: <?= $utility->tariff ?> руб.</small>
                            </div>
                        </div>
                    </div>
                <?php endforeach; ?>
            </div>

            <div class="form-group mt-4">
                <?= Html::submitButton('Сохранить изменения', ['class' => 'btn btn-success btn-lg']) ?>
                <?= Html::a('Отмена', ['index'], ['class' => 'btn btn-secondary btn-lg']) ?>
            </div>

            <?php ActiveForm::end(); ?>
        </div>
    </div>

    <div class="mt-3">
        <?= Html::a('← Назад в админ-панель', ['index'], ['class' => 'btn btn-secondary']) ?>
    </div>
</div>