<?php

use yii\helpers\Html;
use yii\widgets\LinkPager;

$this->title = 'Управление пользователями - Админ-панель';
?>

<div class="admin-users">
    <h1>Управление пользователями</h1>

    <div class="card">
        <div class="card-header">
            <h5 class="card-title mb-0">Зарегистрированные пользователи</h5>
        </div>
        <div class="card-body">
            <?php if (empty($users)): ?>
                <div class="alert alert-info">
                    <p class="mb-0">Пользователи не найдены.</p>
                </div>
            <?php else: ?>
                <div class="table-responsive">
                    <table class="table table-striped">
                        <thead>
                        <tr>
                            <th>ФИО</th>
                            <th>Телефон</th>
                            <th>Email</th>
                            <th>Адрес</th>
                            <th>Проживает</th>
                            <th>Дата регистрации</th>
                            <th>Кол-во показаний</th>
                        </tr>
                        </thead>
                        <tbody>
                        <?php foreach ($users as $user): ?>
                            <tr>
                                <td><?= Html::encode($user->full_name) ?></td>
                                <td><?= Html::encode($user->phone) ?></td>
                                <td><?= Html::encode($user->email) ?></td>
                                <td><?= Html::encode($user->address) ?></td>
                                <td><?= $user->residents_count ?> чел.</td>
                                <td><?= Yii::$app->formatter->asDate($user->created_at, 'php:d.m.Y') ?></td>
                                <td>
                                    <?= $user->getMeterReadings()->count() ?>
                                </td>
                            </tr>
                        <?php endforeach; ?>
                        </tbody>
                    </table>
                </div>

                <?= LinkPager::widget([
                    'pagination' => $pagination,
                    'options' => ['class' => 'pagination justify-content-center'],
                    'linkContainerOptions' => ['class' => 'page-item'],
                    'linkOptions' => ['class' => 'page-link'],
                ]) ?>
            <?php endif; ?>
        </div>
    </div>

    <div class="mt-3">
        <?= Html::a('← Назад в админ-панель', ['index'], ['class' => 'btn btn-secondary']) ?>
    </div>
</div>