<?php

use yii\helpers\Html;
use yii\widgets\ActiveForm;

$this->title = 'Регистрация - Коммуналка';
?>

<div class="auth-register">
    <h1>Регистрация</h1>

    <?php $form = ActiveForm::begin([
        'id' => 'register-form',
        'enableClientValidation' => true,
    ]); ?>

    <?= $form->field($model, 'full_name')->textInput(['maxlength' => true]) ?>

    <div class="row">
        <div class="col-md-6">
            <?= $form->field($model, 'phone')->textInput(['placeholder' => '8(XXX)XXX-XX-XX']) ?>
        </div>
        <div class="col-md-6">
            <?= $form->field($model, 'email')->textInput(['type' => 'email']) ?>
        </div>
    </div>

    <?= $form->field($model, 'address')->textarea(['rows' => 3]) ?>

    <?= $form->field($model, 'residents_count')->textInput(['type' => 'number', 'min' => 1]) ?>

    <div class="row">
        <div class="col-md-6">
            <?= $form->field($model, 'password')->passwordInput() ?>
        </div>
        <div class="col-md-6">
            <?= $form->field($model, 'password_repeat')->passwordInput() ?>
        </div>
    </div>

    <?= $form->field($model, 'agree')->checkbox([
        'template' => "<div class=\"checkbox\">\n{beginLabel}\n{input}\nСогласен с правилами регистрации\n{endLabel}\n{error}\n{hint}\n</div>",
    ]) ?>

    <div class="form-group">
        <?= Html::submitButton('Создать пользователя', ['class' => 'btn btn-success btn-lg']) ?>
    </div>

    <?php ActiveForm::end(); ?>

    <div class="auth-links">
        <p>Уже зарегистрированы? <?= Html::a('Войти', ['auth/login']) ?></p>
    </div>
</div>