<?php

/** @var yii\web\View $this */
/** @var string $content */

use app\assets\AppAsset;
use app\widgets\Alert;
use yii\bootstrap5\Breadcrumbs;
use yii\bootstrap5\Html;
use yii\bootstrap5\Nav;
use yii\bootstrap5\NavBar;

AppAsset::register($this);

$this->registerCsrfMetaTags();
$this->registerMetaTag(['charset' => Yii::$app->charset], 'charset');
$this->registerMetaTag(['name' => 'viewport', 'content' => 'width=device-width, initial-scale=1, shrink-to-fit=no']);
$this->registerMetaTag(['name' => 'description', 'content' => $this->params['meta_description'] ?? 'Портал для передачи показаний счетчиков коммунальных услуг']);
$this->registerMetaTag(['name' => 'keywords', 'content' => $this->params['meta_keywords'] ?? 'коммунальные услуги, показания счетчиков, платежи, ЖКХ']);
$this->registerLinkTag(['rel' => 'icon', 'type' => 'image/x-icon', 'href' => Yii::getAlias('@web/favicon.ico')]);
?>
<?php $this->beginPage() ?>
    <!DOCTYPE html>
    <html lang="<?= Yii::$app->language ?>" class="h-100">
    <head>
        <?php $this->head() ?>
    </head>
    <body class="d-flex flex-column h-100">
    <?php $this->beginBody() ?>

    <header id="header">
        <?php
        NavBar::begin([
            'brandLabel' =>  'Коммуналка',
            'brandUrl' => Yii::$app->homeUrl,
            'options' => ['class' => 'navbar-expand-md navbar-dark bg-success fixed-top']
        ]);

        $menuItems = [
            ['label' => 'Главная', 'url' => ['/site/index']],
        ];

        if (!Yii::$app->user->isGuest) {
            $menuItems[] = ['label' => 'Личный кабинет', 'url' => ['/profile/index']];
            $menuItems[] = ['label' => 'Мои показания', 'url' => ['/readings/index']];
            $menuItems[] = ['label' => 'Передать показания', 'url' => ['/readings/create']];

            // Проверяем, является ли пользователь администратором
            $user = Yii::$app->user->identity;
            if ($user && $user->phone === '8(000)000-00-00') {
                $menuItems[] = ['label' => 'Админ-панель', 'url' => ['/admin/index']];
            }
        }

        if (Yii::$app->user->isGuest) {
            $menuItems[] = ['label' => 'Регистрация', 'url' => ['/auth/register']];
            $menuItems[] = ['label' => 'Вход', 'url' => ['/auth/login']];
        } else {
            $menuItems[] = '<li class="nav-item">'
                . Html::beginForm(['/auth/logout'])
                . Html::submitButton(
                    'Выйти (' . Yii::$app->user->identity->full_name . ')',
                    ['class' => 'nav-link btn btn-link logout']
                )
                . Html::endForm()
                . '</li>';
        }

        echo Nav::widget([
            'options' => ['class' => 'navbar-nav ms-auto'],
            'items' => $menuItems,
        ]);
        NavBar::end();
        ?>
    </header>

    <main id="main" class="flex-shrink-0" role="main" style="padding-top: 70px;">
        <div class="container">
            <?php if (!empty($this->params['breadcrumbs'])): ?>
                <?= Breadcrumbs::widget(['links' => $this->params['breadcrumbs']]) ?>
            <?php endif ?>
            <?= Alert::widget() ?>
            <?= $content ?>
        </div>
    </main>

    <footer id="footer" class="mt-auto py-4 bg-dark text-light">
        <div class="container">
            <div class="row">
                <div class="col-md-4">
                    <h5>Коммуналка</h5>
                    <p>Удобный портал для передачи показаний счетчиков и расчета коммунальных платежей.</p>
                </div>
                <div class="col-md-4">
                    <h5>Контакты</h5>
                    <ul class="list-unstyled">
                        <li>📞 8(800)123-45-67</li>
                        <li>📧 support@kommunalka.ru</li>
                        <li>🕒 Пн-Пт: 9:00-18:00</li>
                    </ul>
                </div>
                <div class="col-md-4">
                    <h5>Полезные ссылки</h5>
                    <ul class="list-unstyled">
                        <li><?= Html::a('Как передать показания?', ['/site/about']) ?></li>
                        <li><?= Html::a('Тарифы', ['/site/tariffs']) ?></li>
                        <li><?= Html::a('Частые вопросы', ['/site/faq']) ?></li>
                    </ul>
                </div>
            </div>
            <hr class="my-3">
            <div class="row">
                <div class="col-md-6 text-center text-md-start">
                    &copy; Портал «Коммуналка» <?= date('Y') ?>
                </div>
                <div class="col-md-6 text-center text-md-end">
                    <?= Yii::powered() ?>
                </div>
            </div>
        </div>
    </footer>

    <?php $this->endBody() ?>
    </body>
    </html>
<?php $this->endPage() ?>