<?php

use yii\helpers\Html;
use yii\widgets\ActiveForm;
use yii\helpers\Url;

$this->title = 'Личный кабинет - Коммуналка';
?>

    <div class="profile-index">
        <div class="row">
            <div class="col-md-3">
                <!-- Боковое меню -->
                <div class="card">
                    <div class="card-header">
                        <h5 class="card-title mb-0">Меню</h5>
                    </div>
                    <div class="list-group list-group-flush">
                        <?= Html::a('Личные данные', ['#personal'], [
                            'class' => 'list-group-item list-group-item-action active',
                            'data-toggle' => 'tab'
                        ]) ?>
                        <?= Html::a('Мои показания', ['readings/index'], [
                            'class' => 'list-group-item list-group-item-action'
                        ]) ?>
                        <?= Html::a('Передать показания', ['readings/create'], [
                            'class' => 'list-group-item list-group-item-action'
                        ]) ?>
                        <?= Html::a('История платежей', ['#payments'], [
                            'class' => 'list-group-item list-group-item-action',
                            'data-toggle' => 'tab'
                        ]) ?>
                        <?= Html::a('Выйти', ['auth/logout'], [
                            'class' => 'list-group-item list-group-item-action text-danger',
                            'data-method' => 'post'
                        ]) ?>
                    </div>
                </div>

                <!-- Статистика -->
                <div class="card mt-3">
                    <div class="card-header">
                        <h5 class="card-title mb-0">Статистика</h5>
                    </div>
                    <div class="card-body">
                        <div class="text-center">
                            <div class="mb-3">
                                <small class="text-muted">Всего передач показаний</small>
                                <h4><?= $readingsCount ?></h4>
                            </div>
                            <div class="mb-3">
                                <small class="text-muted">Принятые показания</small>
                                <h4 class="text-success"><?= $approvedCount ?></h4>
                            </div>
                            <div>
                                <small class="text-muted">На проверке</small>
                                <h4 class="text-warning"><?= $newCount ?></h4>
                            </div>
                        </div>
                    </div>
                </div>
            </div>

            <div class="col-md-9">
                <!-- Основной контент -->
                <div class="card">
                    <div class="card-header">
                        <h4 class="card-title mb-0">Личные данные</h4>
                    </div>
                    <div class="card-body">
                        <?php if (Yii::$app->session->hasFlash('success')): ?>
                            <div class="alert alert-success alert-dismissible fade show" role="alert">
                                <?= Yii::$app->session->getFlash('success') ?>
                                <button type="button" class="close" data-dismiss="alert" aria-label="Close">
                                    <span aria-hidden="true">&times;</span>
                                </button>
                            </div>
                        <?php endif; ?>

                        <?php $form = ActiveForm::begin([
                            'id' => 'profile-form',
                            'options' => ['class' => 'form-horizontal'],
                        ]); ?>

                        <div class="row">
                            <div class="col-md-6">
                                <?= $form->field($model, 'full_name')->textInput([
                                    'maxlength' => true,
                                    'placeholder' => 'Введите ФИО'
                                ]) ?>
                            </div>
                            <div class="col-md-6">
                                <?= $form->field($model, 'phone')->textInput([
                                    'placeholder' => '8(XXX)XXX-XX-XX',
                                    'readonly' => true // Телефон нельзя менять, он используется для входа
                                ]) ?>
                            </div>
                        </div>

                        <?= $form->field($model, 'email')->textInput([
                            'type' => 'email',
                            'placeholder' => 'example@mail.ru'
                        ]) ?>

                        <?= $form->field($model, 'address')->textarea([
                            'rows' => 3,
                            'placeholder' => 'Введите полный адрес проживания'
                        ]) ?>

                        <?= $form->field($model, 'residents_count')->textInput([
                            'type' => 'number',
                            'min' => 1,
                            'placeholder' => 'Количество человек'
                        ]) ?>

                        <hr class="my-4">

                        <h5 class="mb-3">Смена пароля</h5>
                        <p class="text-muted small">Заполняйте только если хотите сменить пароль</p>

                        <div class="row">
                            <div class="col-md-6">
                                <?= $form->field($model, 'password')->passwordInput([
                                    'placeholder' => 'Минимум 10 символов'
                                ]) ?>
                            </div>
                            <div class="col-md-6">
                                <?= $form->field($model, 'password_repeat')->passwordInput([
                                    'placeholder' => 'Повторите пароль'
                                ]) ?>
                            </div>
                        </div>

                        <div class="form-group">
                            <?= Html::submitButton('Сохранить изменения', [
                                'class' => 'btn btn-success btn-lg',
                                'name' => 'update-button'
                            ]) ?>
                            <?= Html::a('Отмена', ['index'], ['class' => 'btn btn-secondary btn-lg']) ?>
                        </div>

                        <?php ActiveForm::end(); ?>
                    </div>
                </div>

                <!-- Последние показания -->
                <div class="card mt-4">
                    <div class="card-header d-flex justify-content-between align-items-center">
                        <h5 class="card-title mb-0">Последние показания</h5>
                        <?= Html::a('Все показания', ['readings/index'], ['class' => 'btn btn-sm btn-outline-primary']) ?>
                    </div>
                    <div class="card-body">
                        <?php if (empty($recentReadings)): ?>
                            <p class="text-muted">У вас еще нет переданных показаний.</p>
                            <?= Html::a('Передать первые показания', ['readings/create'], ['class' => 'btn btn-primary']) ?>
                        <?php else: ?>
                            <div class="table-responsive">
                                <table class="table table-sm">
                                    <thead>
                                    <tr>
                                        <th>Дата</th>
                                        <th>Услуга</th>
                                        <th>Показания</th>
                                        <th>Сумма</th>
                                        <th>Статус</th>
                                    </tr>
                                    </thead>
                                    <tbody>
                                    <?php foreach ($recentReadings as $reading): ?>
                                        <tr>
                                            <td><?= Yii::$app->formatter->asDate($reading->reading_date, 'php:d.m.Y') ?></td>
                                            <td><?= Html::encode($reading->utilityType->name) ?></td>
                                            <td>
                                                <?= $reading->previous_reading ?> →
                                                <?= $reading->current_reading ?>
                                            </td>
                                            <td><?= number_format($reading->amount, 2, '.', ' ') ?> руб.</td>
                                            <td>
                                                <?php
                                                $statusLabels = [
                                                    'new' => '<span class="badge badge-warning">На проверке</span>',
                                                    'approved' => '<span class="badge badge-success">Принято</span>',
                                                    'rejected' => '<span class="badge badge-danger">Ошибка</span>'
                                                ];
                                                echo $statusLabels[$reading->status] ?? $reading->status;
                                                ?>
                                            </td>
                                        </tr>
                                    <?php endforeach; ?>
                                    </tbody>
                                </table>
                            </div>
                        <?php endif; ?>
                    </div>
                </div>

                <!-- Контактная информация -->
                <div class="card mt-4">
                    <div class="card-header">
                        <h5 class="card-title mb-0">Контактная информация и поддержка</h5>
                    </div>
                    <div class="card-body">
                        <div class="row">
                            <div class="col-md-6">
                                <h6>Телефоны поддержки:</h6>
                                <ul class="list-unstyled">
                                    <li>📞 8(800)123-45-67 - Бесплатный по России</li>
                                    <li>📞 8(495)123-45-67 - Москва</li>
                                </ul>
                            </div>
                            <div class="col-md-6">
                                <h6>Электронная почта:</h6>
                                <ul class="list-unstyled">
                                    <li>📧 support@kommunalka.ru - Техническая поддержка</li>
                                    <li>📧 billing@kommunalka.ru - По вопросам платежей</li>
                                </ul>
                            </div>
                        </div>
                        <div class="mt-3">
                            <h6>Часы работы поддержки:</h6>
                            <p>Пн-Пт: 9:00-18:00<br>Сб-Вс: 10:00-16:00</p>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>

<?php
// JavaScript для улучшения UX
$this->registerJs(<<<JS
    // Плавная прокрутка по якорям
    $('.list-group-item[data-toggle="tab"]').on('click', function(e) {
        e.preventDefault();
        var target = $(this).attr('href');
        if (target !== '#') {
            $('html, body').animate({
                scrollTop: $(target).offset().top - 20
            }, 500);
        }
    });

    // Подтверждение выхода
    $('a[data-method="post"]').on('click', function(e) {
        if (!confirm('Вы уверены, что хотите выйти?')) {
            e.preventDefault();
        }
    });

    // Валидация пароля только если он введен
    $('#profile-form').on('beforeSubmit', function() {
        var password = $('#user-password').val();
        var passwordRepeat = $('#user-password_repeat').val();
        
        if (password !== '' && password.length < 10) {
            alert('Пароль должен содержать минимум 10 символов');
            return false;
        }
        
        if (password !== passwordRepeat) {
            alert('Пароли не совпадают');
            return false;
        }
        
        return true;
    });
JS
);
?>