<?php

use yii\helpers\Html;
use yii\widgets\ActiveForm;
use yii\helpers\ArrayHelper;
use yii\helpers\Url;

$this->title = 'Передача показаний - Коммуналка';
?>

    <div class="readings-create">
        <h1>Передача показаний счетчиков</h1>

        <?php $form = ActiveForm::begin([
            'id' => 'reading-form',
        ]); ?>

        <?= $form->field($model, 'utility_type_id')->dropDownList(
            ArrayHelper::map($utilityTypes, 'id', 'name'),
            [
                'prompt' => 'Выберите тип услуги',
                'id' => 'utility-type-select'
            ]
        ) ?>

        <!-- Скрытое поле для previous_reading -->
        <?= $form->field($model, 'previous_reading')->hiddenInput(['id' => 'previous-reading-hidden'])->label(false) ?>

        <!-- Блок для отображения предыдущих показаний -->
        <div class="form-group">
            <label>Предыдущие показания</label>
            <div id="previous-reading-display" class="form-control" style="background-color: #f8f9fa;">
                Не выбрана услуга
            </div>
            <small class="form-text text-muted">Автоматически заполняется системой</small>
        </div>

        <?= $form->field($model, 'current_reading')->textInput([
            'type' => 'number',
            'step' => '0.01',
            'min' => '0',
            'placeholder' => 'Введите текущие показания',
            'id' => 'current-reading-input'
        ]) ?>

        <!-- Блок для предварительного расчета -->
        <div id="calculation-block" class="card mb-3" style="display: none;">
            <div class="card-header">
                <h5 class="mb-0">Предварительный расчет</h5>
            </div>
            <div class="card-body">
                <div class="row">
                    <div class="col-md-4">
                        <strong>Предыдущие:</strong> <span id="previous-display">0</span>
                    </div>
                    <div class="col-md-4">
                        <strong>Расход:</strong> <span id="consumption">0</span> <span id="unit"></span>
                    </div>
                    <div class="col-md-4">
                        <strong>Сумма к оплате:</strong> <span id="amount">0</span> руб.
                    </div>
                </div>
            </div>
        </div>

        <div class="form-group">
            <?= Html::submitButton('Отправить показания', ['class' => 'btn btn-success btn-lg']) ?>
            <?= Html::a('Назад', ['index'], ['class' => 'btn btn-secondary btn-lg']) ?>
        </div>

        <?php ActiveForm::end(); ?>
    </div>

<?php
// Получаем URL для AJAX запросов
$getLastReadingUrl = Url::to(['readings/get-last-reading']);
$getTariffUrl = Url::to(['readings/get-tariff']);

$this->registerJs(<<<JS
    // Функция для получения предыдущих показаний
    function getPreviousReading(utilityTypeId) {
        if (!utilityTypeId) {
            $('#previous-reading-display').text('Не выбрана услуга');
            $('#previous-reading-hidden').val('');
            $('#previous-display').text('0');
            return;
        }
        
        $.get('{$getLastReadingUrl}', {utility_type_id: utilityTypeId})
            .done(function(data) {
                var previousReading = parseFloat(data.previousReading) || 0;
                $('#previous-reading-hidden').val(previousReading);
                $('#previous-reading-display').text(previousReading.toFixed(2));
                $('#previous-display').text(previousReading.toFixed(2));
                calculateConsumption();
            })
            .fail(function(xhr, status, error) {
                console.error('Ошибка загрузки предыдущих показаний:', error);
                $('#previous-reading-display').text('Ошибка загрузки');
                $('#previous-reading-hidden').val('0');
                $('#previous-display').text('0');
            });
    }

    // Функция для расчета расхода и суммы
    function calculateConsumption() {
        var current = parseFloat($('#current-reading-input').val()) || 0;
        var previous = parseFloat($('#previous-reading-hidden').val()) || 0;
        var utilityId = $('#utility-type-select').val();
        
        if (utilityId && current >= 0) {
            var consumption = current - previous;
            $('#consumption').text(consumption.toFixed(2));
            
            // Получаем тариф для выбранной услуги
            $.get('{$getTariffUrl}', {utility_type_id: utilityId})
                .done(function(data) {
                    var amount = consumption * data.tariff;
                    $('#amount').text(amount.toFixed(2));
                    $('#unit').text(data.unit);
                    $('#calculation-block').show();
                })
                .fail(function(xhr, status, error) {
                    console.error('Ошибка загрузки тарифа:', error);
                    $('#calculation-block').hide();
                });
        } else {
            $('#calculation-block').hide();
        }
    }

    // События для полей ввода
    $('#utility-type-select').change(function() {
        var utilityId = $(this).val();
        getPreviousReading(utilityId);
    });

    $('#current-reading-input').on('input', function() {
        calculateConsumption();
    });

    // Валидация при отправке формы
    $('#reading-form').on('beforeSubmit', function(e) {
        var current = parseFloat($('#current-reading-input').val()) || 0;
        var previous = parseFloat($('#previous-reading-hidden').val()) || 0;
        var utilityId = $('#utility-type-select').val();
        
        if (!utilityId) {
            alert('Выберите тип услуги!');
            return false;
        }
        
        if (current <= 0) {
            alert('Введите корректные текущие показания!');
            return false;
        }
        
        if (current < previous) {
            alert('Текущие показания не могут быть меньше предыдущих!');
            return false;
        }
        
        return true;
    });

    // Инициализация при загрузке страницы
    $(document).ready(function() {
        var initialUtilityId = $('#utility-type-select').val();
        if (initialUtilityId) {
            getPreviousReading(initialUtilityId);
        }
    });
JS
);
?>