<?php

use yii\helpers\Html;
use yii\helpers\Url;

$this->title = 'Мои показания - Коммуналка';
?>

<div class="readings-index">
    <h1>История переданных показаний</h1>

    <div class="mb-4">
        <?= Html::a('Передать новые показания', ['create'], ['class' => 'btn btn-success btn-lg']) ?>
        <?= Html::a('Личный кабинет', ['profile/index'], ['class' => 'btn btn-info btn-lg']) ?>
    </div>

    <?php if (empty($readings)): ?>
        <div class="alert alert-info">
            <h4>У вас еще нет переданных показаний</h4>
            <p>Нажмите кнопку "Передать новые показания" чтобы добавить первые показания.</p>
        </div>
    <?php else: ?>
        <div class="table-responsive">
            <table class="table table-striped table-bordered">
                <thead class="thead-dark">
                <tr>
                    <th>Дата передачи</th>
                    <th>Услуга</th>
                    <th>Предыдущие показания</th>
                    <th>Текущие показания</th>
                    <th>Расход</th>
                    <th>Сумма к оплате</th>
                    <th>Статус</th>
                </tr>
                </thead>
                <tbody>
                <?php foreach ($readings as $reading): ?>
                    <tr>
                        <td><?= Yii::$app->formatter->asDate($reading->reading_date, 'php:d.m.Y') ?></td>
                        <td><?= Html::encode($reading->utilityType->name) ?></td>
                        <td><?= $reading->previous_reading ?></td>
                        <td><?= $reading->current_reading ?></td>
                        <td><?= $reading->consumption ?> <?= Html::encode($reading->utilityType->unit) ?></td>
                        <td><?= $reading->amount ?> руб.</td>
                        <td>
                            <?php
                            $statusLabels = [
                                'new' => '<span class="badge badge-warning">Новая</span>',
                                'approved' => '<span class="badge badge-success">Принята</span>',
                                'rejected' => '<span class="badge badge-danger">Ошибка</span>'
                            ];
                            echo $statusLabels[$reading->status] ?? $reading->status;
                            ?>
                        </td>
                    </tr>
                <?php endforeach; ?>
                </tbody>
            </table>
        </div>
    <?php endif; ?>
</div>