<?php

use yii\helpers\Html;
use yii\helpers\Url;

$this->title = 'Коммуналка - Главная';
?>

    <div class="site-index">
        <!-- Слайдер -->
        <?php if (!empty($sliderImages)): ?>
            <div class="slider-container mb-4">
                <div id="mainSlider" class="carousel slide" data-ride="carousel">
                    <div class="carousel-inner">
                        <?php foreach ($sliderImages as $index => $image): ?>
                            <div class="carousel-item <?= $index === 0 ? 'active' : '' ?>">
                                <?= Html::img($image->image_path, [
                                    'class' => 'd-block w-100',
                                    'alt' => $image->title,
                                    'style' => 'height: 400px; object-fit: cover;'
                                ]) ?>
                                <div class="carousel-caption d-none d-md-block">
                                    <h5><?= Html::encode($image->title) ?></h5>
                                    <p><?= Html::encode($image->description) ?></p>
                                </div>
                            </div>
                        <?php endforeach; ?>
                    </div>
                    <a class="carousel-control-prev" href="#mainSlider" role="button" data-slide="prev">
                        <span class="carousel-control-prev-icon" aria-hidden="true"></span>
                        <span class="sr-only">Previous</span>
                    </a>
                    <a class="carousel-control-next" href="#mainSlider" role="button" data-slide="next">
                        <span class="carousel-control-next-icon" aria-hidden="true"></span>
                        <span class="sr-only">Next</span>
                    </a>
                </div>
            </div>
        <?php endif; ?>

        <div class="jumbotron">
            <h1>Добро пожаловать на портал «Коммуналка»!</h1>
            <p class="lead">Удобная передача показаний счетчиков и расчет коммунальных платежей онлайн.</p>

            <?php if (Yii::$app->user->isGuest): ?>
                <p>
                    <?= Html::a('Регистрация', ['auth/register'], ['class' => 'btn btn-success btn-lg']) ?>
                    <?= Html::a('Вход', ['auth/login'], ['class' => 'btn btn-primary btn-lg']) ?>
                </p>
            <?php else: ?>
                <p>
                    <?= Html::a('Передать показания', ['readings/create'], ['class' => 'btn btn-warning btn-lg']) ?>
                    <?= Html::a('Личный кабинет', ['profile/index'], ['class' => 'btn btn-info btn-lg']) ?>
                </p>
            <?php endif; ?>
        </div>

        <div class="body-content">
            <div class="row">
                <div class="col-lg-4">
                    <h2>Как передать показания?</h2>
                    <p>Зарегистрируйтесь, войдите в личный кабинет и нажмите «Передать показания». Выберите тип услуги, введите текущие показания.</p>
                </div>
                <div class="col-lg-4">
                    <h2>Сроки подачи показаний</h2>
                    <p>Показания принимаются с 20 по 25 число каждого месяца. Расчеты производятся до конца месяца.</p>
                </div>
                <div class="col-lg-4">
                    <h2>Контакты и поддержка</h2>
                    <p>Телефон: 8(800)123-45-67<br>Email: support@kommunalka.ru<br>Чат: доступен в личном кабинете</p>
                </div>
            </div>

            <!-- Блок с тарифами -->
            <?php if (!empty($utilityTypes)): ?>
                <div class="row mt-5">
                    <div class="col-12">
                        <h2 class="text-center mb-4">Тарифы на коммунальные услуги</h2>
                        <div class="row">
                            <?php foreach ($utilityTypes as $utility): ?>
                                <div class="col-md-4 mb-3">
                                    <div class="card h-100">
                                        <div class="card-body text-center">
                                            <h5 class="card-title"><?= Html::encode($utility->name) ?></h5>
                                            <p class="card-text display-4 text-primary"><?= $utility->tariff ?> ₽</p>
                                            <p class="card-text">за <?= Html::encode($utility->unit) ?></p>
                                        </div>
                                    </div>
                                </div>
                            <?php endforeach; ?>
                        </div>
                    </div>
                </div>
            <?php endif; ?>
        </div>
    </div>

<?php
// Активируем слайдер только если есть изображения
if (!empty($sliderImages)) {
    $this->registerJs(<<<JS
        $('#mainSlider').carousel({
            interval: 3000
        });
JS
    );
}
?>