<?php

use yii\helpers\Html;
use app\models\UtilityType;

$this->title = 'Тарифы - Коммуналка';

// Получаем тарифы из базы данных
$utilityTypes = UtilityType::find()->all();
?>

<div class="site-tariffs">
    <h1>Тарифы на коммунальные услуги</h1>

    <div class="row">
        <?php foreach ($utilityTypes as $utility): ?>
            <div class="col-md-4 mb-4">
                <div class="card h-100 text-center">
                    <div class="card-header bg-success text-white">
                        <h4 class="card-title mb-0"><?= Html::encode($utility->name) ?></h4>
                    </div>
                    <div class="card-body">
                        <h2 class="text-primary"><?= $utility->tariff ?> ₽</h2>
                        <p class="card-text">за <?= Html::encode($utility->unit) ?></p>
                    </div>
                    <div class="card-footer">
                        <small class="text-muted">Действуют с 01.01.2024</small>
                    </div>
                </div>
            </div>
        <?php endforeach; ?>
    </div>

    <div class="alert alert-warning mt-4">
        <h5>Внимание!</h5>
        <p>Тарифы могут изменяться в соответствии с законодательством РФ. Актуальные тарифы всегда отображаются при передаче показаний.</p>
    </div>
</div>